/*
 * Decompiled with CFR 0.152.
 */
package com.ifractal.utils;

import com.ifractal.ifponto.PushDevice;
import com.ifractal.ifponto.Version;
import com.ifractal.utils.Util;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.ArrayList;
import java.util.LinkedList;
import org.json.simple.JSONObject;

public class HttpServer {
    public static final String HTTP_HEADER = "HTTP/1.1 200 OK\r\nServer: iFractal/" + Version.getText() + "\r\nContent-Type: text/plain;charset=UTF-8\r\n";
    public static final String HTTP_HEADER_ERROR = "HTTP/1.1 406 NOT Registred\r\nServer: iFractal/" + Version.getText() + "\r\nContent-Type: text/plain;charset=UTF-8\r\nContent-Length: 11\r\n\r\nregistry=NO";
    public static final int SERVER_PORT = 8088;
    protected static Thread main_th = null;
    public static int server_port = 8088;
    public static ArrayList<PushDevice<Object>> devices = new ArrayList();
    static int th_qty = 0;
    protected static Runnable loop = new Runnable(){

        @Override
        public void run() {
            ServerSocket ss = null;
            try {
                ss = new ServerSocket(server_port);
                System.out.println("Inicia Push Server em: " + server_port);
                while (true) {
                    Socket cli = ss.accept();
                    HttpServer.httpClient(cli);
                }
            }
            catch (IOException e) {
                System.err.println("Falha ao tentar iniciar Push Server em: " + server_port);
                main_th = null;
                return;
            }
        }
    };

    public static synchronized void removeDevice(PushDevice<Object> dev) {
        dev.cmdQueue.clear();
        dev.confirmList.clear();
        devices.remove(dev);
    }

    public static synchronized void addDevice(PushDevice<Object> dev) {
        if (dev.SN == null || dev.SN.equals("")) {
            dev.sendMessage(3, "SN indefinido.");
        }
        int cnt = 0;
        block0: do {
            for (PushDevice<Object> e : devices) {
                if (dev == e) {
                    return;
                }
                if (!e.SN.equals(dev.SN)) continue;
                ++cnt;
                e.confirmList.clear();
                devices.remove(e);
                continue block0;
            }
        } while (cnt > 0);
        devices.add(dev);
    }

    protected static synchronized PushDevice<Object> getDevice(String ip, String[] dataIn) {
        for (PushDevice<Object> dev : devices) {
            if (dev.ip.equals(ip)) {
                return dev;
            }
            if (!dev.checkDevice(ip, dataIn)) continue;
            return dev;
        }
        return null;
    }

    protected static byte[] handler(PushDevice<Object> dev, String[] dataIn) {
        String[] tk = dataIn[0].split(" ");
        if (tk.length < 3) {
            return null;
        }
        String type = tk[0];
        if ((tk = tk[1].split("\\?")).length < 2) {
            return null;
        }
        String path = tk[0];
        String query = tk[1];
        String[] GET = HttpServer.splitParameters(query, "&", "=");
        String data = "";
        if (type.equals("POST")) {
            data = dataIn[dataIn.length - 1];
        }
        byte[] res = dev.handler(dataIn, type, path, GET, data);
        return res;
    }

    protected static void httpClient(final Socket cli) {
        Runnable peer = new Runnable(){

            @Override
            public void run() {
                ++th_qty;
                try {
                    String line;
                    InputStream is = cli.getInputStream();
                    LinkedList<String> headers = new LinkedList<String>();
                    int len = 0;
                    System.out.println("Requisicao IP: " + cli.getInetAddress() + "\n");
                    while ((line = Util.readLine(is)) != null && line.length() >= 3) {
                        headers.add(line);
                        String[] tk = line.split(": ");
                        if (!tk[0].equals("Content-Length")) continue;
                        len = Integer.parseInt(tk[1]);
                    }
                    if (len > 0) {
                        int n;
                        int pos = 0;
                        byte[] buf = new byte[len];
                        while ((pos += (n = is.read(buf, pos, len - pos))) < len) {
                        }
                        String cnt = new String(buf);
                        headers.add(cnt);
                    }
                    DataOutputStream out = new DataOutputStream(cli.getOutputStream());
                    String[] arr = new String[headers.size()];
                    for (int i = 0; i < arr.length; ++i) {
                        arr[i] = (String)headers.get(i);
                    }
                    byte[] res = null;
                    if (arr.length > 0) {
                        System.out.println(cli.getInetAddress() + " - " + arr[0]);
                        PushDevice<Object> dev = HttpServer.getDevice(cli.getInetAddress().toString().substring(1), arr);
                        if (dev != null) {
                            res = HttpServer.handler(dev, arr);
                        }
                    }
                    if (res != null) {
                        out.write(res, 0, res.length);
                    }
                    is.close();
                    out.close();
                    cli.close();
                }
                catch (InterruptedException ie) {
                    System.err.println("httpClient InterruptedException");
                }
                catch (UnsupportedEncodingException uee) {
                    System.err.println("httpClient UnsupportedEncodingException");
                }
                catch (IOException e) {
                    System.err.println("httpClient IOException");
                }
                --th_qty;
            }
        };
        Thread th = new Thread(peer);
        th.start();
    }

    public static synchronized Thread initServer(JSONObject config) {
        if (main_th != null) {
            return main_th;
        }
        try {
            if (config.containsKey((Object)"HTTP_PORT")) {
                server_port = Integer.parseInt(config.get((Object)"HTTP_PORT").toString());
            }
            if (server_port == 0) {
                return null;
            }
        }
        catch (NumberFormatException nfe) {
            return null;
        }
        main_th = new Thread(loop);
        main_th.start();
        return main_th;
    }

    public static String[] getCookies(String[] headers) {
        for (String e : headers) {
            if (!e.startsWith("Cookie: ")) continue;
            return HttpServer.splitParameters(e.substring(8), ",", "=");
        }
        return null;
    }

    public static String[][] splitTable(String query, String s1, String s2) {
        String[] lns = query.split("\r\n");
        String[][] table = new String[lns.length][];
        int k = 0;
        for (String line : lns) {
            table[k++] = HttpServer.splitParameters(line, " ", s1, s2);
        }
        return table;
    }

    public static String[] splitParameters(String query, String s1, String s2) {
        return HttpServer.splitParameters(query, null, s1, s2);
    }

    public static String[] splitParameters(String query, String init, String s1, String s2) {
        String[] tk;
        LinkedList<String> list = new LinkedList<String>();
        int p = -1;
        if (init != null) {
            p = query.indexOf(init);
        }
        for (String e : tk = query.substring(p + 1).split(s1)) {
            String[] kv = e.split(s2);
            list.add(kv[0]);
            if (kv.length > 1) {
                list.add(kv[1]);
                continue;
            }
            list.add("");
        }
        String[] pars = new String[list.size()];
        for (int i = 0; i < pars.length; ++i) {
            pars[i] = (String)list.get(i);
        }
        return pars;
    }
}

