/*
 * Decompiled with CFR 0.152.
 */
package com.ifractal.image;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import javax.imageio.ImageIO;

public class Barcode {
    private static char[] bits = "0000111100010010100100011010010101101000000011100101001110000001111000000010110101001011000001101100100001011011000000111001000011110100001010000100111100010010100101001010000001111100000110100100011000100101100110000011001100001101110000100010010011011001001000110100100010000111011000011000110001101010010100111000000110110000011111000000101001000111100100001011010000101000010111100001001011000100000011011001001000110001100011010110001000001100110100110010000111001000001001110100100110000110011010001101001100100001100110000111011000001000110001110011000010011100001000100101110010010010011001000010110100011010000100111000010111100000001011000101101100000011110000001010010101101001000011100100000001111001000010110001001011010100101000000110110100011010000101101000000011110100001110000100111010000111001100001001100100100111010010001000011001110001100010010110001000001101110000110010010011000010011100011000100100110010010111001000001001100101100110000011011000001000110101100011000011001100".toCharArray();

    private static void drawStart(Graphics2D gr, int narrow, int height) {
        int x = 0;
        gr.setColor(Color.BLACK);
        gr.fillRect(x, 0, narrow, height);
        gr.setColor(Color.WHITE);
        gr.fillRect(x += narrow, 0, narrow, height);
        gr.setColor(Color.BLACK);
        gr.fillRect(x += narrow, 0, narrow, height);
        gr.setColor(Color.WHITE);
        gr.fillRect(x += narrow, 0, narrow, height);
    }

    private static void drawStop(Graphics2D gr, int narrow, int height) {
        int x = 400 * narrow;
        gr.setColor(Color.BLACK);
        gr.fillRect(x, 0, 3 * narrow, height);
        gr.setColor(Color.WHITE);
        gr.fillRect(x += 3 * narrow, 0, narrow, height);
        gr.setColor(Color.BLACK);
        gr.fillRect(x += narrow, 0, narrow, height);
    }

    private static void drawBarcode(Graphics2D gr, String barcode, int narrow, int height) {
        int len = barcode.length();
        int x = narrow * 4;
        int i = 0;
        while (i + 1 < len) {
            int par;
            try {
                par = Integer.parseInt(barcode.substring(i, i + 2));
            }
            catch (NumberFormatException nfe) {
                System.err.println("Codigo de barras invalido: " + barcode);
                break;
            }
            int bit_index = 10 * par;
            for (int k = 0; k < 10; ++k) {
                if (k % 2 == 0) {
                    gr.setColor(Color.BLACK);
                } else {
                    gr.setColor(Color.WHITE);
                }
                int bar = bits[bit_index + k] == '0' ? narrow : 3 * narrow;
                gr.fillRect(x, 0, bar, height);
                x += bar;
            }
            i += 2;
        }
    }

    public static BufferedImage generateBarcode(String barcodeNumber, int height) {
        int narrow = 1 + height / 60;
        int width = narrow * 405;
        BufferedImage bufImage = new BufferedImage(width, height, 12);
        Graphics2D gr = bufImage.createGraphics();
        gr.setColor(Color.WHITE);
        gr.fillRect(0, 0, width, height);
        Barcode.drawStart(gr, narrow, height);
        Barcode.drawBarcode(gr, barcodeNumber, narrow, height);
        Barcode.drawStop(gr, narrow, height);
        return bufImage;
    }

    public static void saveBarcode(BufferedImage bufImage, String filename) throws IOException {
        File file = new File(filename + ".png");
        ImageIO.write((RenderedImage)bufImage, "png", file);
    }
}

