/*
 * Decompiled with CFR 0.152.
 */
package com.ifractal.ifponto;

import com.ifractal.ifponto.Device;
import com.ifractal.utils.Producer;
import com.ifractal.utils.TunnelClientListener;
import com.ifractal.utils.TunnelNative;
import com.ifractal.utils.TunnelPeer;
import com.ifractal.utils.TunnelServer;
import com.ifractal.utils.Util;
import java.util.Arrays;
import java.util.Date;
import java.util.Objects;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;

public class TunnelDevice<T>
extends Device
implements TunnelClientListener<T> {
    protected String[] response = null;

    public TunnelDevice(JSONObject c) {
        super(c);
        this.addObserver(this);
    }

    public static String[] getModels(Producer prod, String ip, int port) {
        String[] pack = new String[]{"method", "getModels"};
        String[] res = TunnelNative.sendRecv(ip, port + "", pack);
        return res;
    }

    protected String[] sendRecv(String[] args) {
        String host = "127.0.0.1";
        int pack_len = 2 * this.config.size() + args.length;
        String[] pack = new String[pack_len];
        int k = 0;
        for (Object key : this.config.keySet()) {
            if (this.config.get(key) == null) continue;
            pack[k++] = key.toString();
            pack[k++] = this.config.get(key).toString();
        }
        for (int i = 0; i < args.length; ++i) {
            pack[k++] = args[i];
        }
        String[] cleanedPack = (String[])Arrays.stream(pack).filter(Objects::nonNull).toArray(String[]::new);
        this.response = TunnelNative.sendRecv(host, dev_port + "", cleanedPack);
        return this.response;
    }

    @Override
    public void onMessage(T ctx, TunnelServer<T> ts, TunnelPeer<T> peer, String[] pack) {
        this.response = pack;
    }

    @Override
    public void getInfo(JSONObject c) {
        String[] resp = this.sendRecv(new String[]{"method", "getInfo"});
        if (resp == null) {
            return;
        }
        JSONObject info = (JSONObject)Util.getJSONFromArgs(resp, "info");
        if (info == null) {
            return;
        }
        for (Object key : info.keySet()) {
            c.put(key, info.get(key));
        }
    }

    @Override
    public Date getTime() {
        String[] resp = this.sendRecv(new String[]{"method", "getTime"});
        if (resp == null) {
            return null;
        }
        long unixtime = Util.getLongFromArgs(resp, "unixtime") * 1000L;
        Date dt = new Date();
        dt.setTime(unixtime);
        return dt;
    }

    @Override
    public boolean setTime(int diff) {
        String[] resp = this.sendRecv(new String[]{"method", "setTime"});
        return resp != null;
    }

    public int sendGenericUsers(String meth, JSONArray usrs, JSONArray results) {
        String[] pack = new String[]{"method", meth, "users", usrs.toJSONString()};
        String[] resp = this.sendRecv(pack);
        if (resp == null) {
            return -1;
        }
        JSONArray res = (JSONArray)Util.getJSONFromArgs(resp, "result");
        if (res == null) {
            return -2;
        }
        JSONObject reg2 = null;
        for (JSONObject reg2 : res) {
            results.add((Object)reg2);
        }
        int r = Util.getIntFromArgs(resp, "return");
        return r;
    }

    @Override
    public int sendUsers(JSONArray usrs, JSONArray results) {
        return this.sendGenericUsers("sendUsers", usrs, results);
    }

    @Override
    public int sendBio(JSONArray usrs, JSONArray results) {
        return this.sendGenericUsers("sendBio", usrs, results);
    }

    @Override
    public JSONArray getUsers() {
        String[] pack = new String[]{"method", "getUsers"};
        String[] resp = this.sendRecv(pack);
        if (resp == null) {
            return null;
        }
        JSONArray users = (JSONArray)Util.getJSONFromArgs(resp, "users");
        if (users == null) {
            return null;
        }
        return users;
    }

    @Override
    public int getBio(JSONArray usrs) {
        String[] pack = new String[]{"method", "getBio", "users", usrs.toJSONString()};
        String[] resp = this.sendRecv(pack);
        if (resp == null) {
            return -1;
        }
        JSONArray res = (JSONArray)Util.getJSONFromArgs(resp, "users");
        if (res == null) {
            return -1;
        }
        usrs.clear();
        JSONObject reg2 = null;
        for (JSONObject reg2 : res) {
            usrs.add((Object)reg2);
        }
        int r = Util.getIntFromArgs(resp, "return");
        return r;
    }

    @Override
    public int getEvents(JSONArray offs) {
        String[] pack = new String[]{"method", "getEvents", "currentNSR", "" + this.currentNSR};
        String[] resp = this.sendRecv(pack);
        if (resp == null) {
            return -1;
        }
        JSONArray res = (JSONArray)Util.getJSONFromArgs(resp, "offs");
        if (res == null) {
            return -2;
        }
        JSONObject reg2 = null;
        for (JSONObject reg2 : res) {
            offs.add((Object)reg2);
        }
        int r = Util.getIntFromArgs(resp, "nsr");
        return r;
    }
}

