/*
 * Decompiled with CFR 0.152.
 */
package com.ifractal.ifponto;

import com.ifractal.ifponto.ClientListener;
import com.ifractal.ifponto.SIINClient;
import com.ifractal.ifponto.SIINServer;
import com.ifractal.ifponto.ServerListener;
import com.ifractal.utils.Producer;
import com.ifractal.utils.TunnelPeer;
import com.ifractal.utils.Util;
import com.ifractal.utils.Verbosity;
import java.util.Date;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.json.simple.parser.ParseException;

public class DummyUI
implements ClientListener<String>,
ServerListener {
    static SIINClient<String> clientTunnel = null;
    static int port = 0;
    static long startTunnel = 0L;
    static long startLocal = 0L;
    protected static String chave = "";
    protected static DummyUI dummy = null;

    public DummyUI(String[] args) {
    }

    @Override
    public void onAvailable(SIINClient<String> cli, String ctx, JSONArray servers) {
        System.out.println("onAvailable: " + servers.toString());
        if (servers.size() < 1) {
            return;
        }
        JSONObject serv = (JSONObject)servers.get(0);
        Object androidContext = null;
        Object newContext = null;
    }

    @Override
    public void onStart(SIINClient<String> cli, String ctx, JSONObject dev) {
        System.out.println(ctx);
        System.out.println("onStart device");
    }

    @Override
    public void onStop(SIINClient<String> cli, String ctx, JSONObject dev) {
        System.out.println(ctx);
        System.out.println("onStop device");
    }

    @Override
    public void onGetTime(SIINClient<String> cli, String ctx, JSONObject dev, Date date) {
        System.out.println(ctx);
        System.out.println("onGetTime - " + date);
    }

    @Override
    public void onSetTime(SIINClient<String> cli, String ctx, JSONObject dev, int timediff) {
        System.out.println(ctx);
        System.out.println("onSetTime - diff: " + timediff);
    }

    @Override
    public void onSendUser(SIINClient<String> cli, String ctx, JSONObject dev, JSONObject user, JSONObject res, int pos, int total) {
        System.out.println(ctx);
        System.out.println("onSendUser");
    }

    @Override
    public void onGetBio(SIINClient<String> cli, String ctx, JSONObject dev, JSONObject userBios, int pos, int total) {
        System.out.println(ctx);
        System.out.println("onGetBio");
    }

    @Override
    public void onEvents(SIINClient<String> cli, String ctx, JSONObject dev, JSONArray offs) {
        System.out.println(ctx);
        System.out.println("onEvent");
    }

    @Override
    public void onFinalize(SIINClient<String> cli, String ctx, JSONObject dev, boolean online, JSONArray users, JSONArray res) {
        System.out.println(ctx);
        System.out.println("onFinalize - " + online);
    }

    @Override
    public void onResponse(SIINClient<String> cli, String ctx, String[] params) {
        JSONArray jresp = null;
        JSONParser parser = new JSONParser();
        String rsp = Util.getValueFromArgs(params, "onResponse");
        if (rsp == null) {
            return;
        }
        try {
            jresp = (JSONArray)parser.parse(rsp);
        }
        catch (ParseException pe) {
            System.err.println("JSON invalido: -->" + rsp + "<--");
        }
        if (Util.getValueFromArgs(params, "method").equals("getDBDevices")) {
            System.out.println("ActivityDevices: ");
            System.out.println(jresp.toString());
        }
        System.out.println(ctx);
    }

    @Override
    public void onStart(SIINClient<String> cli, String ctx) {
        System.out.println(ctx);
        System.out.println(" onStart ");
        cli.getDBDevices();
    }

    @Override
    public void onStop(SIINClient<String> cli, String ctx) {
        System.out.println(ctx);
        System.out.println(" onStop ");
    }

    @Override
    public void onFail(SIINClient<String> cli, String ctx, String msg) {
        System.out.println(ctx);
        System.out.println("Fail: " + msg);
    }

    @Override
    public void onSynchronized(SIINClient<String> cli, String ctx) {
        System.out.println(ctx);
        System.out.println(" synchronized ");
    }

    @Override
    public void onEnable(SIINClient<String> cli, String ctx, String c) {
        System.out.println(ctx);
        if (c == null || c.length() < 10) {
            System.out.println("modulo n\u00e3o habilitado.");
            return;
        }
        System.out.println("modulo habilitado: " + c);
        if (clientTunnel != null && c.equals(chave)) {
            return;
        }
        chave = c;
        System.out.println("conecta tunnel...");
        SIINClient<String> tncli = new SIINClient<String>(this, c);
        startTunnel = System.currentTimeMillis();
        tncli.connectTunnel();
        clientTunnel = tncli;
    }

    @Override
    public void onMessage(SIINClient<String> cli, String ctx, int level, String msg, int code) {
        String txt = ctx + "|" + Verbosity.getLevel(level) + "|" + code + "| " + msg;
        System.out.println(txt);
    }

    @Override
    public void onConnect(SIINClient<String> cli, String ctx, TunnelPeer<String> p) {
        String ip = p.getIP();
        if (ip.startsWith("/127.0.0.1")) {
            System.out.println(ctx);
            cli.startSIINLoop();
        }
        System.out.println("IP: " + ip);
    }

    @Override
    public void onClose(SIINClient<String> cli, String ctx, TunnelPeer<String> p) {
        if (ctx.equals(DummyUI.clientTunnel.id)) {
            return;
        }
        if (!ctx.equals("local")) {
            return;
        }
        System.out.println("conecta local...");
        SIINClient<String> client = new SIINClient<String>(this, "local");
        client.connect(port);
        startLocal = System.currentTimeMillis();
    }

    @Override
    public void onMessage(Producer prod, int vl, String msg, int code) {
        if (vl >= 5) {
            return;
        }
        String klass = prod.getClass().getName();
        String txt = klass + "|" + Verbosity.getLevel(vl) + "|" + code + "| " + msg;
        System.out.println(txt);
    }

    @Override
    public void onMessage(Producer prod, int verbosityLevel, String msg) {
        this.onMessage(prod, verbosityLevel, msg, 0);
    }

    @Override
    public void onTunnelConnect() {
        System.out.println("onTunnelConnect");
    }

    @Override
    public void onTunnelFail(String msg) {
    }

    @Override
    public void onTunnelClose() {
    }

    @Override
    public void onServerOpen(int port) {
        DummyUI.port = port;
        SIINClient<String> cli = new SIINClient<String>(this, "local");
        cli.connect(port);
        startLocal = System.currentTimeMillis();
        DummyUI.initLoopConnections();
    }

    @Override
    public void onServerFail(String msg) {
        System.out.println("onServerFail...");
    }

    @Override
    public void onServerClose() {
        System.out.println("onServerClose...");
    }

    public static void initLoopConnections() {
        Runnable rn = new Runnable(){

            @Override
            public void run() {
                while (true) {
                    int timeout = 300;
                    if (startTunnel != 0L && (System.currentTimeMillis() - startTunnel) / 1000L > (long)timeout) {
                        SIINClient<String> tncli = new SIINClient<String>(dummy, chave);
                        startTunnel = System.currentTimeMillis();
                        tncli.connectTunnel();
                        clientTunnel = tncli;
                    }
                    if (startLocal == 0L || (System.currentTimeMillis() - startLocal) / 1000L <= (long)timeout) continue;
                    startLocal = System.currentTimeMillis();
                    SIINClient<String> cli = new SIINClient<String>(dummy, "local");
                    cli.connect(port);
                }
            }
        };
        Thread th = new Thread(rn);
        th.start();
    }

    public static final void main(String[] args) throws InterruptedException {
        DummyUI ui;
        if (args.length < 2) {
            System.err.println("\nUso:");
            System.err.println("\tjava DummyUI <KEY1> <VAL1> ... <KEY N> <VAL N>");
            System.err.println("\nExemplo:");
            System.err.println("\tjava DummyUI tunnel_host 74.50.60.155 tunnel_port 80 local_port 9000\n");
            System.exit(1);
            return;
        }
        dummy = ui = new DummyUI(args);
        long[] nativeCtx = null;
        Object androidCtx = null;
        SIINServer.start(nativeCtx, androidCtx, ui, args);
        while (true) {
            Thread.sleep(1000L);
        }
    }
}

