/*
 * Decompiled with CFR 0.152.
 */
package com.ifractal.desktop;

import com.ifractal.desktop.Scanner;
import com.ifractal.desktop.ScannerPanel;
import com.ifractal.ifponto.IfpontoDB;
import com.ifractal.ifponto.SIIN;
import com.ifractal.ifponto.SIINListener;
import com.ifractal.utils.Producer;
import com.ifractal.utils.Util;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.io.File;
import java.io.IOException;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import javax.swing.BoxLayout;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u000b\u0018\u0000 *2\u00020\u00012\u00020\u0002:\u0001*B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0006\u0010\u000f\u001a\u00020\u0010J\u0012\u0010\u0011\u001a\u00020\u00102\b\u0010\u0012\u001a\u0004\u0018\u00010\u0013H\u0016J\u0010\u0010\u0014\u001a\u00020\u00102\u0006\u0010\u0015\u001a\u00020\u0013H\u0016J\b\u0010\u0016\u001a\u00020\u0010H\u0016J1\u0010\u0017\u001a\u00020\u00182\u0010\u0010\u0019\u001a\f\u0012\u0006\u0012\u0004\u0018\u00010\u001b\u0018\u00010\u001a2\b\u0010\u001c\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u001d\u001a\u00020\u001bH\u0000\u00a2\u0006\u0002\b\u001eJ$\u0010\u0017\u001a\u00020\u00102\b\u0010\u001f\u001a\u0004\u0018\u00010 2\u0006\u0010!\u001a\u00020\u00182\b\u0010\u001c\u001a\u0004\u0018\u00010\u0013H\u0016J,\u0010\u0017\u001a\u00020\u00102\b\u0010\u001f\u001a\u0004\u0018\u00010 2\u0006\u0010!\u001a\u00020\u00182\b\u0010\u001c\u001a\u0004\u0018\u00010\u00132\u0006\u0010\"\u001a\u00020\u0018H\u0016J\"\u0010#\u001a\u00020\u00102\u0006\u0010$\u001a\u00020\u00182\u0006\u0010%\u001a\u00020\u00182\b\u0010&\u001a\u0004\u0018\u00010\u0013H\u0016J\b\u0010'\u001a\u00020\u0010H\u0016J\b\u0010(\u001a\u00020\u0010H\u0016J\b\u0010)\u001a\u00020\u0010H\u0016R\u001c\u0010\u0004\u001a\u0004\u0018\u00010\u0001X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\bR\u001c\u0010\t\u001a\u0004\u0018\u00010\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000e\u00a8\u0006+"}, d2={"Lcom/ifractal/desktop/ProgressBarUI;", "Ljavax/swing/JPanel;", "Lcom/ifractal/ifponto/SIINListener;", "()V", "mainPanel", "getMainPanel", "()Ljavax/swing/JPanel;", "setMainPanel", "(Ljavax/swing/JPanel;)V", "progressBar", "Ljavax/swing/JProgressBar;", "getProgressBar", "()Ljavax/swing/JProgressBar;", "setProgressBar", "(Ljavax/swing/JProgressBar;)V", "init", "", "onEnable", "key", "", "onFail", "message", "onIdle", "onMessage", "", "scan", "Lcom/ifractal/desktop/Scanner;", "Lcom/ifractal/desktop/ScannerPanel;", "msg", "panel", "onMessage$ifractal", "prod", "Lcom/ifractal/utils/Producer;", "level", "code", "onProgress", "progressTotal", "progressPos", "notify", "onStart", "onStop", "onSynchronized", "Companion", "ifractal"})
public final class ProgressBarUI
extends JPanel
implements SIINListener {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private JPanel mainPanel;
    @Nullable
    private JProgressBar progressBar;

    @Nullable
    public final JPanel getMainPanel() {
        return this.mainPanel;
    }

    public final void setMainPanel(@Nullable JPanel jPanel) {
        this.mainPanel = jPanel;
    }

    @Nullable
    public final JProgressBar getProgressBar() {
        return this.progressBar;
    }

    public final void setProgressBar(@Nullable JProgressBar jProgressBar) {
        this.progressBar = jProgressBar;
    }

    public final void init() {
        this.mainPanel = new JPanel();
        this.setLayout(new BorderLayout());
        BoxLayout bl = new BoxLayout(this.mainPanel, 0);
        JPanel jPanel = this.mainPanel;
        if (jPanel != null) {
            jPanel.setLayout(bl);
        }
        this.add((Component)this.mainPanel, "Center");
        this.progressBar = new JProgressBar();
        JPanel jPanel2 = this.mainPanel;
        if (jPanel2 != null) {
            jPanel2.add(this.progressBar);
        }
        JPanel jPanel3 = this.mainPanel;
        if (jPanel3 != null) {
            jPanel3.setVisible(true);
        }
        this.setVisible(true);
    }

    public final int onMessage$ifractal(@Nullable Scanner<ScannerPanel> scan, @Nullable String msg, @NotNull ScannerPanel panel) {
        Intrinsics.checkNotNullParameter((Object)panel, (String)"panel");
        panel.updateMessage(msg);
        return 0;
    }

    @Override
    public void onMessage(@Nullable Producer prod, int level, @Nullable String msg, int code) {
        DateTimeFormatter dt = DateTimeFormatter.ofPattern("yyyyMMdd");
        LocalDateTime dtNow = LocalDateTime.now();
        try {
            Util.createLogFile("log" + File.separator + "monitor_" + dt.format(dtNow) + ".log", msg + '\n');
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    @Override
    public void onMessage(@Nullable Producer prod, int level, @Nullable String msg) {
        this.onMessage(prod, level, msg, 0);
    }

    @Override
    public void onEnable(@Nullable String key) {
    }

    @Override
    public void onStart() {
    }

    @Override
    public void onStop() {
    }

    @Override
    public void onIdle() {
    }

    @Override
    public void onFail(@NotNull String message) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
    }

    @Override
    public void onProgress(int progressTotal, int progressPos, @Nullable String notify) {
        JProgressBar jProgressBar = this.progressBar;
        if (jProgressBar != null) {
            jProgressBar.setStringPainted(true);
        }
        JProgressBar jProgressBar2 = this.progressBar;
        if (jProgressBar2 != null) {
            jProgressBar2.setValue(progressPos * 100 / progressTotal);
        }
    }

    @Override
    public void onSynchronized() {
    }

    @JvmStatic
    public static final void main(@NotNull String[] args) {
        Companion.main(args);
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001b\u0010\u0003\u001a\u00020\u00042\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006H\u0007\u00a2\u0006\u0002\u0010\b\u00a8\u0006\t"}, d2={"Lcom/ifractal/desktop/ProgressBarUI$Companion;", "", "()V", "main", "", "args", "", "", "([Ljava/lang/String;)V", "ifractal"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        public final void main(@NotNull String[] args) {
            Intrinsics.checkNotNullParameter((Object)args, (String)"args");
            if (args.length == 0) {
                System.err.println("Uso:");
                System.err.println("\t$ java Scanner -\n");
                System.exit(1);
                throw new RuntimeException("System.exit returned normally, while it was supposed to halt JVM.");
            }
            JFrame window = new JFrame();
            ProgressBarUI progressbarui = new ProgressBarUI();
            String[] stringArray = new String[]{"DB", "conf/ifponto.db", "CLIENTID", "desenvolvimento", "VERBOSITY", "5", "READERS", "5", "WEBHOST", "stou.ifractal.com.br"};
            String[] args2 = stringArray;
            IfpontoDB db = new IfpontoDB(args2, progressbarui);
            SIIN siin = SIIN.getInstance(args2, db, progressbarui);
            progressbarui.init();
            window.add(progressbarui);
            window.setTitle("Biodesktop");
            window.setDefaultCloseOperation(3);
            window.setLocationRelativeTo(null);
            window.setSize(new Dimension(600, 500));
            window.setVisible(true);
            db.init(args2, progressbarui);
            db.open(progressbarui);
            SIIN sIIN = siin;
            if (sIIN != null) {
                sIIN.startSIINLoop();
            }
            db.close();
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

