/*
 * Decompiled with CFR 0.152.
 */
package com.ifractal.image;

import java.awt.Color;
import java.awt.Font;
import java.awt.GradientPaint;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.awt.image.WritableRaster;
import java.io.File;
import java.io.IOException;
import java.util.Random;
import javax.imageio.ImageIO;

public class Captcha {
    static final int width = 300;
    static final int height = 60;

    public static BufferedImage createImage(String text) {
        int i;
        int xGap = 30;
        int yGap = 25;
        int[] fontSize = new int[]{26, 29, 27, 28};
        String[] fontName = new String[]{"Arial"};
        Color gradiantStartColor = new Color(60, 60, 60);
        Color gradiantEndColor = new Color(140, 140, 140);
        Color textColor = new Color(255, 153, 0);
        BufferedImage bufferedImage = new BufferedImage(300, 60, 5);
        Graphics2D g2d = bufferedImage.createGraphics();
        RenderingHints rh = new RenderingHints(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        rh.put(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        g2d.setRenderingHints(rh);
        GradientPaint gp = new GradientPaint(0.0f, 0.0f, gradiantStartColor, 0.0f, 30.0f, gradiantEndColor, true);
        g2d.setPaint(gp);
        g2d.fillRect(0, 0, 300, 60);
        Random r = new Random();
        for (int i2 = 0; i2 < 290; i2 += 30) {
            int q = Math.abs(r.nextInt()) % 300;
            int colorIndex = Math.abs(r.nextInt()) % 200;
            g2d.setColor(new Color(colorIndex, colorIndex, colorIndex));
            g2d.drawLine(i2, q, 300, 60);
            g2d.drawLine(q, i2, i2, 60);
        }
        g2d.setColor(textColor);
        int x = 0;
        int y = 0;
        for (i = 0; i < text.length(); ++i) {
            Font font = new Font(fontName[i % fontName.length], 1, fontSize[i % fontSize.length]);
            g2d.setFont(font);
            y = yGap + Math.abs(r.nextInt()) % 20;
            g2d.drawChars(text.toCharArray(), i, 1, x += xGap + Math.abs(r.nextInt()) % 15, y);
        }
        for (i = 0; i < 290; i += 30) {
            int p = Math.abs(r.nextInt()) % 300;
            int q = Math.abs(r.nextInt()) % 300;
            int colorIndex = Math.abs(r.nextInt()) % 200;
            g2d.setColor(new Color(colorIndex, colorIndex, colorIndex));
            g2d.drawLine(p, 0, i + p, q);
            g2d.drawLine(p, 0, i + 25, 60);
        }
        g2d.dispose();
        Captcha.distortion(bufferedImage);
        return bufferedImage;
    }

    private static void distortion(BufferedImage buf) {
        int y = 0;
        int x = 0;
        WritableRaster wraster = buf.getRaster();
        try {
            x = 1;
            for (y = 0; y < 60; ++y) {
                byte[] pixels1 = (byte[])buf.getData().getDataElements(0, y, 300 - x, 1, null);
                buf.getData().getDataElements(300 - x, y, x, 1, null);
                wraster.setDataElements(x, y, 300 - x, 1, pixels1);
                wraster.setDataElements(0, y, x, 1, pixels1);
                x = (y * y * 60 - y * y * y) / 1500 + 1;
            }
        }
        catch (ArrayIndexOutOfBoundsException aioob) {
            System.err.println("(x,y):(" + x + "," + y + ")");
        }
    }

    public static final void main(String[] args) {
        String text = args.length < 1 ? "TestCaptcha" : args[0];
        BufferedImage bufimg = Captcha.createImage(text);
        try {
            File file = new File("teste.png");
            ImageIO.write((RenderedImage)bufimg, "png", file);
        }
        catch (IOException ioe) {
            System.err.println("Erro IO");
        }
    }
}

