/*
 * Decompiled with CFR 0.152.
 */
package com.ifractal.ifponto;

import com.ifractal.ifponto.BatchRequest;
import com.ifractal.ifponto.Device;
import com.ifractal.ifponto.IFPONTO_config;
import com.ifractal.ifponto.IfaceDevice;
import com.ifractal.ifponto.NativeDevice;
import com.ifractal.ifponto.UserWebRequest;
import com.ifractal.utils.FiledirIter;
import com.ifractal.utils.Getopts;
import com.ifractal.utils.IfaceFilePerform;
import com.ifractal.utils.Util;
import com.ifractal.utils.Verbosity;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.json.simple.parser.ParseException;

@Deprecated
public class Manager
extends Verbosity
implements Runnable,
IfaceDevice {
    private static HashMap<String, Device> devices = new HashMap();
    private static HashMap<String, String> config = null;
    private IfaceDevice dm = null;

    public Manager() {
        this.dm = this;
    }

    public Manager(IfaceDevice ifd, HashMap<String, String> c) {
        this.dm = ifd;
        config = c;
    }

    @Override
    public Device getNewDevice(JSONObject params) {
        Device dev = Device.getNewDevice(params);
        return dev;
    }

    public void initModule(String[] params) {
        config = IFPONTO_config.getParams();
        Getopts.parseStringArray(config, params);
        Getopts.parseIniFile(config, IFPONTO_config.filename);
        int level = Getopts.getIntValue(config, "VERBOSITY");
        this.setLevel(level);
        this.verboseDEBUG("config=" + String.valueOf(config));
        this.verbose("VERBOSITY=" + level);
        try {
            JSONObject jo = new JSONObject();
            jo.putAll(config);
            Util.loadLibrary(jo);
            Device.initC(jo.toString());
        }
        catch (UnsatisfiedLinkError ule) {
            this.verboseFATAL("Falha ao tentar carregar library: " + ule.getMessage());
        }
        Thread mth = new Thread((Runnable)this, "Manager");
        mth.start();
        Runnable uwr = new Runnable(){

            @Override
            public void run() {
                int port = Manager.getIntValue("VERBOSITY_PORT");
                if (port > 0) {
                    UserWebRequest.webServerRun(Manager.this, port);
                }
            }
        };
        Thread uwr_th = new Thread(uwr, "UserWebRequest");
        uwr_th.start();
    }

    public void finalizeModule() {
        this.verboseINFO("finaliza");
    }

    public static String getConfigValue(String key) {
        return config.get(key).toString();
    }

    public static int getIntValue(String key) {
        return Getopts.getIntValue(config, key);
    }

    public static int Iface_getTime(Device dev, Object json, String[] result) {
        Date dt = dev.getTime();
        if (dt == null) {
            return IFPONTO_config.valueOf((String)"ERRO_COMUNICACAO").codigo;
        }
        result[0] = dt.toString();
        return 0;
    }

    public static int Iface_setTime(Device dev, Object arg, String[] result) {
        boolean r;
        int diff = 0;
        if (arg != null && arg instanceof String && !arg.equals("-")) {
            diff = Integer.parseInt((String)arg);
        }
        if (r = dev.setTime(diff)) {
            return 0;
        }
        return IFPONTO_config.valueOf((String)"ERRO_COMUNICACAO").codigo;
    }

    public static int Iface_getInfo(Device dev, Object json, String[] result) {
        JSONObject jconf = json == null || !(json instanceof JSONObject) ? new JSONObject() : (JSONObject)json;
        dev.getInfo(jconf);
        result[0] = jconf.toString();
        return 0;
    }

    public static int Iface_getEvents(Device dev, Object json, String[] result) {
        JSONArray offs = new JSONArray();
        int nsr = dev.getEvents(offs);
        if (nsr < 0) {
            return IFPONTO_config.valueOf((String)"ERRO_COLETA_EVENTOS").codigo;
        }
        result[0] = offs.toString();
        return 0;
    }

    public static int Iface_sendUsers(Device dev, Object json, String[] result) {
        if (json == null || !(json instanceof JSONArray)) {
            return IFPONTO_config.valueOf((String)"JSON_INVALIDO").codigo;
        }
        JSONArray jusers = (JSONArray)json;
        JSONArray res = new JSONArray();
        int n = dev.sendUsers(jusers, res);
        if (n < 0) {
            return IFPONTO_config.valueOf((String)"ERRO_INSERT_USER").codigo;
        }
        result[0] = res.toString();
        return 0;
    }

    public static int Iface_getUsers(Device dev, Object json, String[] result) {
        JSONArray users = dev.getUsers();
        if (users == null) {
            return IFPONTO_config.valueOf((String)"ERRO_GET_USERS").codigo;
        }
        result[0] = users.toString();
        return 0;
    }

    public static int Iface_sendBio(Device dev, Object json, String[] result) {
        if (json == null || !(json instanceof JSONArray)) {
            return IFPONTO_config.valueOf((String)"JSON_INVALIDO").codigo;
        }
        JSONArray jusers = (JSONArray)json;
        JSONArray res = new JSONArray();
        int n = dev.sendBio(jusers, res);
        if (n < 0) {
            return IFPONTO_config.valueOf((String)"ERRO_INSERT_BIO").codigo;
        }
        result[0] = res.toString();
        return 0;
    }

    public static int Iface_getBio(Device dev, Object json, String[] result) {
        if (json == null || !(json instanceof JSONArray)) {
            return IFPONTO_config.valueOf((String)"JSON_INVALIDO").codigo;
        }
        JSONArray jusers = (JSONArray)json;
        int n = dev.getBio(jusers);
        if (n < 0) {
            return IFPONTO_config.valueOf((String)"ERRO_GET_BIO").codigo;
        }
        result[0] = jusers.toString();
        return 0;
    }

    public static int Iface_getBioList(Device dev, Object json, String[] result) {
        JSONArray jlist = dev.getBioList();
        if (jlist == null) {
            return IFPONTO_config.valueOf((String)"ERRO_GET_BIO").codigo;
        }
        result[0] = jlist.toString();
        return 0;
    }

    public static int Iface_online(Device dev, Object json, String[] result) {
        int r = dev.getEndIterDelay();
        return r;
    }

    public static synchronized int Iface_getAllDevices(Device dev, Object json, String[] result) {
        JSONArray arr = new JSONArray();
        for (Map.Entry<String, Device> e : devices.entrySet()) {
            Device d = e.getValue();
            arr.add((Object)d.config);
        }
        result[0] = arr.toString();
        return 0;
    }

    public static synchronized int Iface_resume(Device dev, Object json, String[] result) {
        dev.config.remove((Object)"suspended");
        dev.verboseINFO("resume...");
        return 0;
    }

    public static synchronized int Iface_suspend(Device dev, Object json, String[] result) {
        dev.config.put((Object)"suspended", (Object)1);
        dev.verboseINFO("suspend...");
        return 0;
    }

    public static int Iface_getModels(Device dev, Object json, String[] result) {
        JSONParser parser = new JSONParser();
        JSONArray jmodels = new JSONArray();
        String smodels = "";
        try {
            smodels = Device.getModelsC(dev.config.toString());
            jmodels = (JSONArray)parser.parse(smodels);
        }
        catch (ParseException pe) {
            System.err.println(IFPONTO_config.valueOf((String)"JSON_INVALIDO").msg);
            System.err.println("'" + smodels + "'");
        }
        catch (UnsatisfiedLinkError ule) {
            System.err.println("Implementacoes C e Mono/.Net indisponiveis.");
        }
        for (String[] m : Device.class_models) {
            for (int i = 1; i < m.length; ++i) {
                jmodels.add((Object)m[i]);
            }
        }
        result[0] = jmodels.toString();
        return 0;
    }

    public static int Iface_getMethods(Device dev, Object json, String[] result) {
        Method[] meths = Manager.class.getMethods();
        JSONArray jmethods = new JSONArray();
        for (Method m : meths) {
            String nm = m.getName();
            if (!nm.startsWith("Iface_")) continue;
            jmethods.add((Object)nm.substring(6));
        }
        result[0] = jmethods.toString();
        return 0;
    }

    public static int performCall(Device dev, String cmd, String sjson, String[] result) {
        JSONParser parser = new JSONParser();
        Object json = sjson;
        int r = 0;
        try {
            if (Manager.checkAbstract(cmd)) {
                int to;
                if (!dev.config.containsKey((Object)"suspended")) {
                    return IFPONTO_config.valueOf((String)"RELOGIO_NAO_SUSPENSO").codigo;
                }
                for (to = 60; to > 0 && Manager.isAlive(dev.config); --to) {
                    Thread.sleep(1000L);
                }
                if (to <= 0) {
                    return IFPONTO_config.valueOf((String)"EM_PROCESSAMENTO").codigo;
                }
            }
            if (sjson != null && (sjson.startsWith("[") || sjson.startsWith("{"))) {
                json = parser.parse(sjson);
            }
            Method meth = Manager.class.getMethod("Iface_" + cmd, Device.class, Object.class, String[].class);
            r = (Integer)meth.invoke(null, dev, json, result);
        }
        catch (InterruptedException ie) {
            result[0] = ie.getMessage();
            return IFPONTO_config.valueOf((String)"ERRO_INTERNO").codigo;
        }
        catch (InvocationTargetException iae) {
            result[0] = "Falha ao tentar executar: " + cmd + " - Cause: " + String.valueOf(iae.getCause());
            return IFPONTO_config.valueOf((String)"ERRO_INTERNO").codigo;
        }
        catch (IllegalAccessException iae) {
            result[0] = iae.getMessage();
            return IFPONTO_config.valueOf((String)"ERRO_INTERNO").codigo;
        }
        catch (NoSuchMethodException nsme) {
            result[0] = nsme.getMessage();
            return IFPONTO_config.valueOf((String)"COMANDO_INVALIDO").codigo;
        }
        catch (ParseException pe) {
            result[0] = pe.getMessage();
            return IFPONTO_config.valueOf((String)"JSON_INVALIDO").codigo;
        }
        catch (ClassCastException cce) {
            result[0] = cce.getMessage();
            return IFPONTO_config.valueOf((String)"ERRO_INTERNO").codigo;
        }
        return r;
    }

    public static int performCall(String nro, String cmd, String json, String[] result) {
        Device dev;
        JSONObject cdummy = new JSONObject();
        String[] fields = new String[]{"nro", "0", "modelo", "generic", "verbosity", "5"};
        if (nro.equals("0")) {
            int i = 0;
            while (i + 1 < fields.length) {
                cdummy.put((Object)fields[i], (Object)fields[i + 1]);
                ++i;
            }
            dev = new NativeDevice(cdummy);
        } else {
            dev = Manager.getDevice(nro);
        }
        if (dev == null) {
            return IFPONTO_config.valueOf((String)"NAO_ENCONTRADO").codigo;
        }
        int r = Manager.performCall(dev, cmd, json, result);
        return r;
    }

    public static synchronized Device getDevice(String nro) {
        Device dev = devices.get(nro);
        return dev;
    }

    public static synchronized void insertDevice(Device dev) {
        devices.put(dev.getNro(), dev);
    }

    public static int performConfig(String filename, JSONArray readers) throws IOException {
        JSONObject reader;
        JSONParser parser = new JSONParser();
        String nro = "";
        try {
            FileReader fr = new FileReader(filename);
            reader = (JSONObject)parser.parse((Reader)fr);
            fr.close();
            if (!reader.containsKey((Object)"nro")) {
                return 0;
            }
            nro = reader.get((Object)"nro").toString();
        }
        catch (ParseException pe) {
            Verbosity.println(filename + " - Erro em " + pe.getPosition());
            return 0;
        }
        String conf_readers = Manager.getConfigValue("READERS");
        if (conf_readers.length() > 0) {
            for (String r : conf_readers.split(",")) {
                if (!nro.equals(r.trim())) continue;
                readers.add((Object)reader);
                return 0;
            }
            int n = BatchRequest.clean(nro);
            if (n > 0) {
                Verbosity.println("Ignora leitor: " + nro + " - descarrega fila: " + n);
            }
        } else {
            readers.add((Object)reader);
        }
        return 0;
    }

    public static boolean isAlive(JSONObject conf) {
        int th_qty = Thread.activeCount();
        Thread[] ths = new Thread[th_qty + 10];
        int q = Thread.enumerate(ths);
        Object nro = conf.get((Object)"nro");
        if (nro == null) {
            Verbosity.println("JSON invalido: campo 'nro' nao encontrado.");
            return true;
        }
        for (int i = 0; i < q; ++i) {
            if (!ths[i].getName().equals(nro.toString())) continue;
            return true;
        }
        return false;
    }

    @Override
    public void run() {
        JSONParser parser = new JSONParser();
        JSONArray readers = null;
        String path_log = config.get("PATH_LOG");
        while (true) {
            try {
                while (true) {
                    FiledirIter fdi = new FiledirIter(path_log);
                    readers = new JSONArray();
                    IfaceFilePerform fp = new IfaceFilePerform(){

                        @Override
                        public int filePerform(String filename, Object user_data) throws IOException {
                            JSONArray readers = (JSONArray)user_data;
                            String[] prefix = new String[]{"list_", "bio_", "prebio_"};
                            if (filename.indexOf("config_") > 0) {
                                Manager.performConfig(filename, readers);
                            }
                            for (String p : prefix) {
                                if (filename.indexOf(p) <= 0) continue;
                                BatchRequest.put(Manager.this, filename);
                            }
                            return 0;
                        }
                    };
                    fdi.perform(fp, "", ".json", readers);
                    BatchRequest.clean();
                    Iterator iterator = readers.iterator();
                    Device dev = null;
                    while (iterator.hasNext()) {
                        Device d;
                        JSONObject r = (JSONObject)iterator.next();
                        if (!(Manager.isAlive(r) || (d = Manager.getDevice(r.get((Object)"nro").toString())) != null && d.config.containsKey((Object)"suspended"))) {
                            for (Map.Entry<String, String> entry : config.entrySet()) {
                                r.put((Object)entry.getKey(), (Object)entry.getValue());
                            }
                            if (!r.containsKey((Object)"verbosity")) {
                                r.put((Object)"verbosity", (Object)this.getLevel());
                            }
                            JSONObject clone = (JSONObject)parser.parse(r.toString());
                            this.verboseDEBUG(clone.toString());
                            dev = this.dm.getNewDevice(clone);
                            if (dev != null) {
                                Manager.insertDevice(dev);
                                this.verboseDEBUG("Start: " + dev.getNro());
                                Thread th = new Thread((Runnable)dev, dev.getNro());
                                th.start();
                            }
                        }
                        dev = null;
                    }
                    Thread.sleep(10000L);
                }
            }
            catch (InterruptedException ie) {
                this.verboseFATAL("thread fail: " + ie.getMessage());
            }
            catch (ParseException pe) {
                this.verboseFATAL(pe.getMessage());
                continue;
            }
            break;
        }
    }

    private static int showIfaceMethods() {
        Method[] meths = Manager.class.getMethods();
        int i = 0;
        for (Method m : meths) {
            String nm = m.getName();
            if (nm.startsWith("Iface_")) {
                System.err.println("\t" + nm.substring(6));
            }
            ++i;
        }
        return i;
    }

    public static String[] getAbstractMethods() {
        Method[] meths = Device.class.getMethods();
        String[] ret2 = new String[meths.length];
        int i = 0;
        for (Method m : meths) {
            int mod = m.getModifiers();
            if ((mod & 0x400) == 0) continue;
            ret2[i++] = m.getName();
        }
        return ret2;
    }

    public static boolean checkAbstract(String cmd) {
        String[] ms;
        for (String m : ms = Manager.getAbstractMethods()) {
            if (m == null) break;
            if (!cmd.equals(m)) continue;
            return true;
        }
        return false;
    }

    public static final void main(String[] args) {
        String file;
        String[] dev_default = new String[]{"suspended", "1", "codigo", "1", "nro", "1", "modelo", "dummy", "ip", "172.30.253.97", "porta", "3000"};
        String[] pre = new String[]{"verbosity", "0", "library", "ifdevice4j", "dotnet_namespace", "ifponto", "dotnet_class", "NativeDevice", "tempo_aguardando_giro", "3"};
        Manager mn = new Manager();
        if (args.length == 1 && args[0].equals("test")) {
            mn.initModule(pre);
            try {
                while (true) {
                    Thread.sleep(1000L);
                }
            }
            catch (InterruptedException ie) {
                System.exit(11);
                System.exit(0);
            }
        }
        if (args.length < 2) {
            System.err.println("iFractal - Device Unit Teste");
            System.err.println("\nUso:");
            System.err.println("\tshell$ java com.ifractal.ifponto.Manager <CMD> <Arquivo JSON> <Param 1> <Val 1> ... <Param N> <Val N>");
            System.err.println("\nOnde <CMD>:");
            Manager.showIfaceMethods();
            System.err.println("\nOnde <Param>");
            int i = 0;
            while (i + 1 < pre.length) {
                System.err.printf("%25s  -  default: '%s'\n", pre[i], pre[i + 1]);
                i += 2;
            }
            i = 0;
            while (i + 1 < dev_default.length) {
                System.err.printf("%25s  -  default: '%s'\n", dev_default[i], dev_default[i + 1]);
                i += 2;
            }
            System.err.println("\nExemplos:");
            System.err.println("\tshell$ java com.ifractal.ifponto.Manager getInfo - modelo idclass nro 2");
            System.err.println("\tshell$ java com.ifractal.ifponto.Manager sendUsers list_1_zzz.json modelo idclass nro 3");
            System.err.println("OU\n\tshell$ java com.ifractal.ifponto.Manager test\n");
            System.exit(1);
        } else if (args.length % 2 != 0) {
            System.err.println("\nParametros devem vir em pares <chave> <valor>.\n");
            System.exit(2);
        }
        JSONObject jconf = new JSONObject();
        int i = 0;
        while (i + 1 < pre.length) {
            jconf.put((Object)pre[i], (Object)pre[i + 1]);
            i += 2;
        }
        i = 0;
        while (i + 1 < dev_default.length) {
            jconf.put((Object)dev_default[i], (Object)dev_default[i + 1]);
            i += 2;
        }
        i = 2;
        while (i + 1 < args.length) {
            jconf.put((Object)args[i], (Object)args[i + 1]);
            i += 2;
        }
        try {
            Util.loadLibrary(jconf);
            Device.initC(jconf.toString());
        }
        catch (UnsatisfiedLinkError ule) {
            System.err.println("Ignora initC");
        }
        Device dev = mn.getNewDevice(jconf);
        if (dev == null) {
            System.exit(3);
        }
        String cmd = args[0];
        String json = file = args[1];
        if (!file.equals("-") && (json = Util.getContent(file)) == null) {
            json = file;
        }
        String[] res = new String[1];
        int r = Manager.performCall(dev, cmd, json, res);
        String msg = res[0];
        if (msg == null) {
            msg = IFPONTO_config.getMsg(r);
        }
        System.out.println(msg);
        System.exit(r);
    }
}

