/*
 * Decompiled with CFR 0.152.
 */
package com.henry.hexa;

import com.henry.hexa.Auth;
import com.henry.hexa.MessagePack;
import java.util.ArrayList;

public class MessageManager {
    public static final byte HEADER_START_BTYE = 2;
    public static final int HEADER_START_BTYE_SIZE = 1;
    private static final int CHECK_SUM = 1;
    private static final int MIN_STEPS = 2;
    public static final byte HEADER_END_BTYE = 3;
    public static final int HEADER_END_BTYE_SIZE = 1;
    public static final byte HEADER_MIN_SIZE = 5;
    public static final byte HEADER_SEP_1 = 43;
    public static final byte HEADER_SEP_2 = 93;
    public static final byte HEADER_SEP_3 = 91;
    public static final byte HEADER_SEP_4 = 125;

    private static Object initLoadHeader(byte[] idx, byte[] cmd, byte[] data, String aesKey) {
        int sizeMsg;
        int dataSize = data.length;
        String cmdComplement = "00";
        StringBuilder aux = new StringBuilder();
        aux.append(new String(idx));
        aux.append("+");
        aux.append(new String(cmd));
        aux.append("+");
        aux.append(cmdComplement);
        byte[] pack = aux.toString().getBytes();
        if (dataSize > 0) {
            pack = MessageManager.concatArrays(pack, {43}, data);
        }
        byte[] content = pack;
        if (aesKey.equals("")) {
            sizeMsg = pack.length;
        } else {
            byte[] encodedArr = Auth.encodeAES(aesKey, pack);
            sizeMsg = encodedArr.length;
            pack = encodedArr;
        }
        ArrayList<Object> r = new ArrayList<Object>();
        r.add(sizeMsg);
        r.add(pack);
        r.add(content);
        return r;
    }

    public static byte[] loadHeader(byte[] idx, byte[] cmd, byte[] data, String aesKey, byte[][] bpack) {
        try {
            ArrayList pack = (ArrayList)MessageManager.initLoadHeader(idx, cmd, data, aesKey);
            int sizeMsg = (Integer)pack.get(0);
            byte[] aux = (byte[])pack.get(1);
            byte[] content = (byte[])pack.get(2);
            byte chksum = 0;
            bpack[0] = content;
            int size = 3 + sizeMsg + 1 + 1;
            int i = 0;
            byte[] arraytmp = new byte[size];
            arraytmp[i++] = 2;
            arraytmp[i++] = (byte)(sizeMsg & 0xFF);
            arraytmp[i++] = (byte)(sizeMsg >> 8 & 0xFF);
            for (int j = 0; j < sizeMsg; ++j) {
                arraytmp[i++] = aux[j];
            }
            for (int k = 1; k < size - 2; ++k) {
                chksum = (byte)(chksum ^ arraytmp[k]);
            }
            arraytmp[i++] = chksum;
            arraytmp[i++] = 3;
            return arraytmp;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static MessagePack loadObject(byte[] data, String aesKey, byte[][] bdata) {
        byte[] decodedArr = new byte[]{};
        try {
            MessagePack obj = new MessagePack("", "", "", "");
            int size = data.length;
            byte chksum = 0;
            int i = 0;
            if (size < 5) {
                return null;
            }
            if (data[i++] != 2) {
                return null;
            }
            int pckgSize = data[i++] & 0xFF;
            if ((pckgSize += (data[i++] & 0xFF) * 256) > size - 5) {
                return null;
            }
            for (int j = 1; j < pckgSize + 3; ++j) {
                chksum = (byte)(chksum ^ data[j]);
            }
            if (chksum != data[pckgSize + 3]) {
                System.err.println("Falha checksum....");
                return null;
            }
            data[pckgSize + 3] = 0;
            Object msgIdx = "";
            Object cmdCode = "";
            Object errorCode = "";
            String cmdData = "";
            if (!aesKey.equals("")) {
                if (pckgSize < 17) {
                    return null;
                }
                byte[] iv = new byte[16];
                byte[] encodedArr = new byte[pckgSize - iv.length];
                System.arraycopy(data, i, iv, 0, iv.length);
                System.arraycopy(data, i += iv.length, encodedArr, 0, pckgSize - iv.length);
                decodedArr = Auth.decodeAES(aesKey, encodedArr, iv);
                if (decodedArr == null) {
                    return null;
                }
                size = decodedArr.length;
                data = decodedArr;
            }
            for (i = 0; i < size && data[i] != 43; ++i) {
                msgIdx = (String)msgIdx + data[i];
            }
            obj.setIdx((String)msgIdx);
            ++i;
            while (i < size && data[i] != 43) {
                cmdCode = (String)cmdCode + new String(data, i++, 1);
            }
            obj.setCmd((String)cmdCode);
            ++i;
            while (i < size && data[i] != 43 && data[i] != 0) {
                errorCode = (String)errorCode + new String(data, i++, 1);
            }
            obj.setErro((String)errorCode);
            while (i < size && data[i] != 43) {
                ++i;
            }
            if (size > 0 && ++i < size) {
                cmdData = new String(data, i, size - i);
                obj.setData(cmdData);
            }
            bdata[0] = data;
            obj.setRawData(data);
            return obj;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static byte[] concatArrays(byte[] ... chunks) {
        int i;
        int off = 0;
        int len = 0;
        if (chunks == null || chunks.length < 1) {
            return null;
        }
        if (chunks.length < 2) {
            return chunks[0];
        }
        for (i = 0; i < chunks.length; ++i) {
            if (chunks[i] == null) continue;
            len += chunks[i].length;
        }
        byte[] res = new byte[len];
        for (i = 0; i < chunks.length; ++i) {
            if (chunks[i] == null) continue;
            for (int k = 0; k < chunks[i].length; ++k) {
                res[off++] = chunks[i][k];
            }
        }
        return res;
    }
}

